Module Module1

  Public Sub TestGenericException()

    Dim I As Integer
    Dim Numerator As Integer = 5
    Dim Denominator As Integer = 0

    Try
      I = Numerator \ Denominator
      Debug.WriteLine(I)
    Catch e As System.DivideByZeroException
      MsgBox(e.Message)
    End Try

  End Sub

  Public Sub TestMultipleExceptions()
    BackupFile("sample.txt")
  End Sub

  Public Sub BackupFile(ByVal FileName As String)
    Dim F As System.IO.File
    Try
      F.Delete(FileName + ".bak")
      F.Copy(FileName, FileName + ".bak")

    Catch e As System.UnauthorizedAccessException When F.Exists(FileName + ".bak")
      MsgBox(e.Message)
      Throw
    Catch e As System.IO.FileNotFoundException
      MsgBox(e.Message)
    End Try

  End Sub

  Public Sub WriteText(ByVal FileName As String, ByVal SomeText As String)

    Try
      Dim W As New System.IO.StreamWriter(FileName, True)

      Try
        W.WriteLine(SomeText)
      Finally
        W.Close()
      End Try

    Catch e As System.UnauthorizedAccessException
      MsgBox(e.Message, MsgBoxStyle.Critical)
    End Try

  End Sub

End Module
